package treeNAlgo;

import treeN.*;
import treeNAlgo.*;
import java.util.*;
import extvisitor.*;

/**
 * InsertNAlgo2  -  inserts the supplied parameter (key) into a TreeN
 *  preserving balance with a maximum number of elements per node.
 *  Utilizes lambda-based extended visitors
 */
public class InsertNAlgo2<E> extends ATreeNAlgo<E, TreeN<E>, E> {
  
  
  /**
   * Splits host upwards if its state &gt; order and splices it into
   * its parent.    The supplied param is an ISpliceCmd used to do the
   * splicing.
   */
  private SplitUpAndApply2<E> splitUpAndSplice;
  
  
  private Comparator<E> comp = new Comparator<E>() {
    public int compare(E o1, E o2) {
      return ((Comparable<E>)o1).compareTo(o2);
    }
  };
  
  
  /**
   * 
   * @param order -- the max possible number of elements in a node
   */
  public InsertNAlgo2(int order) {
    System.out.println("InsertNAlgo2 instantiated.  order = "+order);
    
    splitUpAndSplice = new SplitUpAndApply2<E>(order);
    
    setCmd(0,new IExtVisitorCmd<TreeN<E>,Integer, E, TreeN<E>>(){
      public TreeN<E> apply(Integer index, TreeN<E> host, E... keys) {
        return host.spliceAt(0, new TreeN<E>(keys[0]));
      }
    });   

    setDefaultCmd(new IExtVisitorCmd<TreeN<E>,Integer, E, TreeN<E>>(){      
      public TreeN<E> apply(Integer index, final TreeN<E> host, final E... keys) {
        
        host.execute(new ATreeNAlgo<E, TreeN<E>, ILambda<TreeN<E>,TreeN<E>>>() {
          
          private ATreeNAlgo<E, TreeN<E>, ILambda<TreeN<E>,TreeN<E>>> this_helper = this;
          
          // Initializer block
          {
            setDefaultCmd(new IExtVisitorCmd<TreeN<E>,Integer, ILambda<TreeN<E>,TreeN<E>>, TreeN<E>>(){
              
              public TreeN<E> apply(Integer s_help, final TreeN<E> h, ILambda<TreeN<E>,TreeN<E>>... cmds) {
                final int[] x={0};  // trick to get past restrictions on final
                // x[0] is the index of insertion location.
                for(; x[0] < s_help; x[0]++) {// find insertion location
                  E d = h.getDat(x[0]);
                  if(0 < comp.compare(d, keys[0])) {
                    if (d.equals(keys[0]))
                      return h; // no duplicate keys allowed
                    else break;
                  }
                }
                h.getChild(x[0]).execute(this_helper, new ILambda<TreeN<E>,TreeN<E>>() {
                  /**
                   * @param child a TreeN subtree of h.
                   */
                  public TreeN<E> apply(TreeN<E>... child){
                    // splice child tree into parent
                    return h.spliceAt(x[0],child[0]);
                  }
                }
                );
                // split up host if necessary
                return h.execute(splitUpAndSplice, cmds);
              }
            });
            setCmd(0,new IExtVisitorCmd<TreeN<E>,Integer, ILambda<TreeN<E>,TreeN<E>>, TreeN<E>>(){
              public TreeN<E> apply(Integer index, TreeN<E> host, ILambda<TreeN<E>,TreeN<E>>... cmds) {
                /**
                 * At this point the host is an empty subtree of some parent
                 * tree. Because the parent tree is balanced, it must be a
                 * leaf!
                 */
                return cmds[0].apply(new TreeN<E>(keys[0]));
              }
            });
          }
        }, new ILambda<TreeN<E>, TreeN<E>>() {// say something meaningful here
          public TreeN<E> apply(TreeN<E>... nu){
            return host;  //no-op for this one
          }
        });
        return host;
      }
    });    
  }  
}

